#include "types.h"

#include <util/string/join.h>

#include <sstream>

namespace NNwSmtp::NDlv {

std::string ToString(EDlvType type) {
    switch (type) {
        case EDlvType::Sync:
            return "sync";
        case EDlvType::Restore:
            return "restore";
        case EDlvType::Mailish:
            return "mailish";
        case EDlvType::Imap:
            return "imap";
        case EDlvType::Save:
            return "save";
        case EDlvType::Collectors:
            return "collectors";
        default:
            return "unknown";
    }
}

std::string ToString(const TOptions& options) {
    std::stringstream ss;
    ss << "enable_push=" << options.EnablePush.value_or(false) << ", ";
    ss << "detect_spam=" << options.DetectSpam.value_or(false) << ", ";
    ss << "detect_virus=" << options.DetectVirus.value_or(false) << ", ";
    ss << "detect_cycle=" << options.DetectCycle.value_or(false) << ", ";
    ss << "use_filters=" << options.UseFilters.value_or(false) << ", ";
    ss << "allow_duplicates=" << options.AllowDuplicates.value_or(false) << ", ";
    ss << "dlv_type=" << ToString(options.DlvType) << ", ";
    ss << "so_out=" << options.SoOut << ", ";
    ss << "skip_meta_msg=" << options.SkipMetaMsg << ", ";
    ss << "un_dot_stuffing=" << options.UnDotStuffing.value_or(false);
    return ss.str();
}

std::string ToString(const TMailInfo& mailInfo) {
    std::stringstream ss;
    ss << "fid=" << mailInfo.Fid << ", ";
    ss << "folder_path=" << mailInfo.FolderPath.value_or(std::string{}) << ", ";
    ss << "folder_spam_path=" << mailInfo.FolderSpamPath.value_or(std::string{}) << ", ";
    ss << "folder_path_delim=" << mailInfo.FolderPathDelim.value_or(std::string{}) << ", ";
    ss << "received_date=" << mailInfo.ReceivedDate.value_or(0) << ", ";
    if (mailInfo.Labels) {
        ss << "lids=(" << JoinSeq(", ", mailInfo.Labels->Lids.value_or(TLabelList{})) << "), ";
        ss << "system=(" << JoinSeq(", ", mailInfo.Labels->System.value_or(TLabelList{})) << "), ";
        ss << "imap=(" << JoinSeq(", ", mailInfo.Labels->Imap.value_or(TLabelList{})) << "), ";
        ss << "symbol=(" << JoinSeq(", ", mailInfo.Labels->Symbol.value_or(TLabelList{})) << "), ";
        ss << "userlabel=(" << JoinSeq(", ", mailInfo.Labels->User.value_or(TLabelList{})) << "), ";
    }
    ss << "external_imap_id=" << mailInfo.ExternalImapId << ", ";
    ss << "old_mid=" << mailInfo.OldMid.value_or(std::string{}) << ", ";
    ss << "tab=" << mailInfo.Tab << ", ";
    ss << "stid=" << mailInfo.Stid;
    return ss.str();
}

std::string ToString(const TUserInfo& userInfo) {
    std::stringstream ss;
    ss << "uid=" << userInfo.Uid << ", ";
    ss << "email=" << userInfo.Email << ", ";
    return ss.str();
}

}  // namespace NNwSmtp::NDlv
