#pragma once

#include <mail/nwsmtp/src/types.h>

#include <functional>
#include <string>
#include <set>
#include <ctime>

namespace NNwSmtp::NDlv {

enum class EDlvType {
    Sync,
    Restore,
    Mailish,
    Imap,
    Save,
    Collectors
};

std::string ToString(EDlvType type);

struct TEnvelopeInfo {
    std::string RequestId;
    std::string SessionId;
    std::string EnvId;
    std::string RemoteIp;
    std::string RemoteHost;
};

struct TOptions {
    std::optional<bool> EnablePush;
    std::optional<bool> DetectSpam;
    std::optional<bool> DetectVirus;
    std::optional<bool> DetectCycle;
    std::optional<bool> UseFilters;
    std::optional<bool> AllowDuplicates;
    std::optional<bool> UnDotStuffing = false;
    bool SoOut = false;
    bool SkipMetaMsg = false;
    EDlvType DlvType = EDlvType::Sync;
};

std::string ToString(const TOptions& options);

using TLabelList = std::vector<std::string>;

struct TLabels {
    std::optional<TLabelList> System;
    std::optional<TLabelList> Imap;
    std::optional<TLabelList> Symbol;
    std::optional<TLabelList> Lids;
    std::optional<TLabelList> User;
};

struct TMailInfo {
    std::string Fid;
    std::optional<std::string> FolderPath;
    std::optional<std::string> FolderSpamPath;
    std::optional<std::string> FolderPathDelim;
    std::optional<std::time_t> ReceivedDate;
    std::optional<TLabels> Labels;
    std::string ExternalImapId;
    std::optional<std::string> OldMid;
    std::string Stid;
    std::string Tab;
};

std::string ToString(const TMailInfo& mailInfo);

struct TUserInfo {
    std::string Uid;
    std::string Email;
};

std::string ToString(const TUserInfo& userInfo);

struct TSyncResult {
    std::string Mid;
    std::string ImapId;
};

struct TRequest {
    TMailInfo MailInfo;
    TUserInfo UserInfo;
    std::optional<TOptions> Options;
};

using TSyncResultCallback = std::function<void(TErrorCode, TSyncResult)>;

}  // namespace NNwSmtp::NDlv
