#pragma once

#include <mail/nwsmtp/src/delivery/sync/types.h>

#include <boost/fusion/adapted.hpp>
#include <yamail/data/reflection/reflection.h>


YREFLECTION_ADAPT_ADT(NNwSmtp::NDlv::TLabels,
    YREFLECTION_MEMBER_RENAMED(std::optional<NNwSmtp::NDlv::TLabelList>, system, System)
    YREFLECTION_MEMBER_RENAMED(std::optional<NNwSmtp::NDlv::TLabelList>, imap, Imap)
    YREFLECTION_MEMBER_RENAMED(std::optional<NNwSmtp::NDlv::TLabelList>, symbol, Symbol)
    YREFLECTION_MEMBER_RENAMED(std::optional<NNwSmtp::NDlv::TLabelList>, lids, Lids)
    YREFLECTION_MEMBER_RENAMED(std::optional<NNwSmtp::NDlv::TLabelList>, user, User)
)

YREFLECTION_ADAPT_ADT(NNwSmtp::NDlv::TMailInfo,
    YREFLECTION_MEMBER_RENAMED(std::optional<std::string>, folder_path, FolderPath)
    YREFLECTION_MEMBER_RENAMED(std::optional<std::string>, folder_spam_path, FolderSpamPath)
    YREFLECTION_MEMBER_RENAMED(std::optional<std::string>, folder_path_delim, FolderPathDelim)
    YREFLECTION_MEMBER_RENAMED(std::optional<std::time_t>, received_date, ReceivedDate)
    YREFLECTION_MEMBER_RENAMED(std::optional<NNwSmtp::NDlv::TLabels>, labels, Labels)
    YREFLECTION_MEMBER_RENAMED(std::optional<std::string>, old_mid, OldMid)
)

YREFLECTION_ADAPT_ADT(NNwSmtp::NDlv::TUserInfo,
    YREFLECTION_MEMBER_RENAMED(std::string, email, Email)
)

YREFLECTION_ADAPT_ADT(NNwSmtp::NDlv::TOptions,
    YREFLECTION_MEMBER_RENAMED(std::optional<bool>, enable_push, EnablePush)
    YREFLECTION_MEMBER_RENAMED(std::optional<bool>, detect_spam, DetectSpam)
    YREFLECTION_MEMBER_RENAMED(std::optional<bool>, detect_virus, DetectVirus)
    YREFLECTION_MEMBER_RENAMED(std::optional<bool>, detect_loop, DetectCycle)
    YREFLECTION_MEMBER_RENAMED(std::optional<bool>, use_filters, UseFilters)
    YREFLECTION_MEMBER_RENAMED(std::optional<bool>, allow_duplicates, AllowDuplicates)
    YREFLECTION_MEMBER_RENAMED(std::optional<bool>, un_dot_stuffing , UnDotStuffing)
)

YREFLECTION_ADAPT_ADT(NNwSmtp::NDlv::TRequest,
    YREFLECTION_MEMBER_RENAMED(NNwSmtp::NDlv::TMailInfo, mail_info, MailInfo)
    YREFLECTION_MEMBER_RENAMED(NNwSmtp::NDlv::TUserInfo, user_info, UserInfo)
    YREFLECTION_MEMBER_RENAMED(std::optional<NNwSmtp::NDlv::TOptions>, options, Options)
)
