#pragma once

#include "config.h"

#include <mail/nwsmtp/src/avir/types.h>
#include <mail/nwsmtp/src/context.h>
#include <mail/nwsmtp/src/delivery/sync/types.h>
#include <mail/nwsmtp/src/header_storage.h>
#include <mail/nwsmtp/src/nsls/types.h>
#include <mail/nwsmtp/src/so/request.h>
#include <mail/nwsmtp/src/so/types.h>
#include <mail/nwsmtp/src/utils.h>
#include <mail/nwsmtp/src/types.h>
#include <mail/nwsmtp/src/xyandexhint/extractor.h>

#include <mail/sova/include/nwsmtp/avir_client.h>

#include <optional>

namespace NNwSmtp::NDlv {

NNsls::TRequest BuildStoreRequest(
    const TOptions& options,
    const TEnvelopeInfo& envInfo,
    const TUserInfo& userInfo,
    const std::string& stid,
    bool isSpam,
    NHint::TParamsContainer hint
);

std::string BuildReceivedHeader(
    const TEnvelopeInfo& envInfo,
    const TUserInfo& userInfo,
    const std::string& clusterName
);

NSO::TRequestPtr BuildSoRequest(
    const TOptions& options,
    const TEnvelopeInfo& envInfo,
    const TUserInfo& userInfo,
    const TMailInfo& mailInfo,
    const TBufferRange& body,
    const THeaderStorageImpl& headers,
    const TConfigPtr& config
);

void ChangeTab(
    std::optional<NSO::TResponse>& soResult,
    const std::string& tab
);

std::pair<TErrorCode, TSyncResult> MakeStoreResult(const NNsls::TResponse& nslsResponse);
TErrorCode MakeAvirResult(const NAvir::TStatus& result);
TErrorCode MakeSoResult(
    const std::optional<NSO::TResponse>& result,
    const TOptions& options,
    bool captcha
);

std::string SoResultToString(const std::optional<NSO::TResponse>& result);
std::string AvirResultToString(const NAvir::TStatus& result);

std::string GetSoEmailType(EDlvType dlvtype);
bool GetSoDryRun(EDlvType dlvtype, bool dryRun);
std::string BuildDecyclerHeader(std::size_t decyclerCount);
bool GetCaptchaWasEntered(const THeaderStorage<TBufferRange>& headers);
std::size_t GetDecyclerCounter(const THeaderStorage<TBufferRange>& headers);

bool DetectCycle(const TConfigPtr& config, const TOptions& options, std::size_t decyclerCounter);

} // namespace NNwSmtp::NDlv
