#pragma once

#include "dkim_options.h"
#include "adkim.h"

#include <yplatform/reactor.h>

#include <ymod_httpclient/call.h>

#include <yplatform/module.h>
#include <memory>

namespace NNwSmtp {

class Dkim: public yplatform::module {
public:
    explicit Dkim(yplatform::reactor& reactor);
    virtual void init(const yplatform::ptree& pt);

    void sign(const dkim_sign::input&, dkim_sign::Handler);
    std::shared_ptr<dkim_check> check(const dkim_check::input&, const resolver_options& resolver_options, dkim_check::Handler);

    const DkimOptions& getOptions() const { return *options; }

private:
    yplatform::reactor& reactor;
    std::shared_ptr<DkimOptions> options;
    std::shared_ptr<ymod_httpclient::cluster_call> httpClient;
};

DkimOptions::dkim_mode GetDkimMode();
bool AllowSkipDkimSign();

void AsyncDkimCheck(
    const dkim_check::input& data,
    const resolver_options& resolverOpts,
    dkim_check::Handler handler);

void AsyncDkimSign(const dkim_sign::input& input, dkim_sign::Handler handler);

}   // namespace NNwSmtp
