#pragma once

#include <yplatform/ptree.h>
#include <chrono>
#include <unordered_map>
#include <unordered_set>
#include <set>
#include <vector>
#include <string>

namespace NNwSmtp {

using ptree = yplatform::ptree;

struct DkimOptions
{
    struct KeyEntry {
        std::string selector;
        std::string domain;
        std::string secretkey;
    };

    struct SignOptions {
        using Keys = std::unordered_map<std::string, KeyEntry>;
        Keys keys;

        std::unordered_set<std::string> sign_hdrs;
        std::unordered_set<std::string> skip_hdrs;

        bool allow_skip_sign = true;
        bool use_fouras = false;
    };

    enum dkim_mode
    {
        none,
        sign,
        signverify,
        verify
    } mode = none;

    SignOptions signOpts;

    unsigned int timeout = 1;
    unsigned int threadsToParseKeys = 16;

    DkimOptions() = default;
    DkimOptions(const ptree& pt);

    void read(const ptree& pt);
};

std::vector<std::string> GeDkimDefaultSignedHeaders();
std::vector<std::string> GeDkimDefaultNotSignedHeaders();

}   // namespace NNwSmtp
