#pragma once

#include <mail/nwsmtp/src/context.h>

#include <nwsmtp/resolver.h>

#include <functional>
#include <memory>
#include <optional>

namespace NNwSmtp {
namespace dmarc {

    struct record {
        std::string m_version;
        std::string m_domain;

        enum policy {
            UNKNOWN = -1, NONE = 0, QUARANTINE, REJECT
        };

        policy m_policy = UNKNOWN;
        policy m_subdomain_policy = UNKNOWN;

        bool m_strict_dkim = false;
        bool m_strict_spf = false;
        unsigned int percent = 100;
        std::string failureOpts = "0";
        std::string rua;
    };

    class checker : public std::enable_shared_from_this<checker>
    {
    public:
        checker(boost::asio::io_service &io_service, const resolver_options&);

        typedef std::function<void (std::optional<record>)> result_callback;

        void start(const std::string &domain, const result_callback &handler, TContextPtr context);
        void stop();
        const std::string& get_txt_record() const;
    private:

        using resolver_t = NNwSmtp::resolver_t;

        void handle_resolve(const boost::system::error_code &error, resolver_t::iterator_txt result);
        void handle_timeout(const boost::system::error_code &error);
        void handle_error(const std::string &message);

        void resolve(const std::string &domain);
        void cancel();

        void report(bool success = true);

        boost::asio::io_service &m_io_service;
        boost::asio::io_service::strand m_strand;
        boost::asio::deadline_timer m_timer;
        resolver_t m_resolver;

        result_callback m_handler;
        TContextPtr Context;
        bool m_tld_fallback;

        record m_record;
        std::string m_txt_record;
    };

    std::string convert_policy(record::policy value);

}   // namespace dmarc
}   // namespace NNwSmtp
