#include "alignment.h"
#include "exceptions.h"

#include <libopendmarc/dmarc.h>

#include <cassert>

namespace NNwSmtp::NOpenDmarc {

const char* ToString(EAlignment alignment) {
    switch (alignment) {
        case EAlignment::Pass:
            return "Pass";
        case EAlignment::Fail:
            return "Fail";
    }
    assert(false);
    return "";
}

EAlignment ToAlignment(int alignment) {
    switch (alignment) {
        case DMARC_POLICY_DKIM_ALIGNMENT_PASS:
            return EAlignment::Pass;
        case DMARC_POLICY_DKIM_ALIGNMENT_FAIL:
            return EAlignment::Fail;
        default:
            throw TDmarcException("Unknown alignment");
    }
}

}  // namespace NNwSmtp::NOpenDmarc

