#include "alignment_mode.h"
#include "exceptions.h"

#include <libopendmarc/dmarc.h>

#include <cassert>

namespace NNwSmtp::NOpenDmarc {

EAlignMode ToAlignMode(int alignMode) {
    switch (alignMode) {
        case DMARC_RECORD_A_UNSPECIFIED:
            return EAlignMode::Unspecified;
        case DMARC_RECORD_A_RELAXED:
            return EAlignMode::Relaxed;
        case DMARC_RECORD_A_STRICT:
            return EAlignMode::Strict;
        default:
            throw TDmarcException("Unknown alignment mode");
    }
}

const char* ToString(EAlignMode mode) {
    switch (mode) {
        case EAlignMode::Unspecified:
            return "Unspecified";
        case EAlignMode::Relaxed:
            return "Relaxed";
        case EAlignMode::Strict:
            return "Strict";
    }
    assert(false);
    return "";
}

}  // namespace NNwSmtp::NOpenDmarc
