#include "context.h"
#include "util.h"

namespace NNwSmtp::NOpenDmarc {

TContext::TContext() noexcept
    : TContext("", 0) {}  // We do not want the library to go to network
                         // so use any ip addr and ip type.
TContext::TContext(const std::string& ipAddr, int ipType) noexcept
    : DataPtr(Allocate(ipAddr, ipType)) {}

void TContext::Reset() noexcept {
    opendmarc_policy_connect_rset(DataPtr.get());
}

DMARC_POLICY_T* TContext::Get() noexcept {
    return DataPtr.get();
}

TContext::TDmarcPolicyPtr TContext::Allocate(const std::string& ipAddr, int ipType) noexcept {
    TDmarcPolicyPtr dmarcPolicyPtr{nullptr, &opendmarc_policy_connect_shutdown};
    auto* rawPtr = opendmarc_policy_connect_init(ToUchar(ipAddr), ipType);
    dmarcPolicyPtr.reset(rawPtr);
    return dmarcPolicyPtr;
}

}  // namespace NNwSmtp::NOpenDmarc
