#pragma once

#include <libopendmarc/dmarc.h>

#include <string>
#include <memory>

namespace NNwSmtp::NOpenDmarc {

class TContext {
public:
    using TDmarcPolicyPtr =
        std::unique_ptr<
            DMARC_POLICY_T,
            decltype(&opendmarc_policy_connect_shutdown)>;

    TContext() noexcept;
    TContext(const std::string& ipAddr, int ipType) noexcept;
    void Reset() noexcept;
    DMARC_POLICY_T* Get() noexcept;
    static TDmarcPolicyPtr Allocate(const std::string& ipAddr, int ipType) noexcept;

private:
    TDmarcPolicyPtr DataPtr;
};

}  // namespace NNwSmtp::NOpenDmarc
