#include "dmarc_policy.h"
#include "exceptions.h"

#include <libopendmarc/dmarc.h>

#include <cassert>

namespace NNwSmtp::NOpenDmarc {

const char* ToString(EDmarcPolicy policy) {
    switch (policy) {
        case EDmarcPolicy::Absent:
            return "Absent";
        case EDmarcPolicy::None:
            return "None";
        case EDmarcPolicy::Reject:
            return "Reject";
        case EDmarcPolicy::Quarantine:
            return "Quarantine";
        case EDmarcPolicy::Pass:
            return "Pass";
    }
    assert(false);
    return "";
}

EDmarcPolicy ToDmarcPolicy(int policy) {
    switch (policy) {
        case DMARC_POLICY_ABSENT:
            return EDmarcPolicy::Absent;
        case DMARC_POLICY_NONE:
            return EDmarcPolicy::None;
        case DMARC_POLICY_REJECT:
            return EDmarcPolicy::Reject;
        case DMARC_POLICY_QUARANTINE:
            return EDmarcPolicy::Quarantine;
        case DMARC_POLICY_PASS:
            return EDmarcPolicy::Pass;
        default:
            throw TDmarcException("Unknown dmarc policy");
    }
}

}  // namespace NNwSmtp::NOpenDmarc
