#include "domain_policy.h"
#include "exceptions.h"

#include <libopendmarc/dmarc.h>

#include <cassert>

namespace NNwSmtp::NOpenDmarc {

const char* ToString(EDomainPolicy policy) {
    switch (policy) {
        case EDomainPolicy::Unspecified:
            return "Unspecified";
        case EDomainPolicy::None:
            return "None";
        case EDomainPolicy::Quarantine:
            return "Quarantine";
        case EDomainPolicy::Reject:
            return "Reject";
    }
    assert(false);
    return "";
}

EDomainPolicy ToDomainPolicy(int policy) {
    switch (policy) {
        case DMARC_RECORD_P_UNSPECIFIED:
            return EDomainPolicy::Unspecified;
        case DMARC_RECORD_P_NONE:
            return EDomainPolicy::None;
        case DMARC_RECORD_P_QUARANTINE:
            return EDomainPolicy::Quarantine;
        case DMARC_RECORD_P_REJECT:
            return EDomainPolicy::Reject;
        default:
            throw TDmarcException("Unknown domain policy");
    }
}

}  // namespace NNwSmtp::NOpenDmarc
