#pragma once

#include <libopendmarc/dmarc.h>

#include <stdexcept>
#include <string>

namespace NNwSmtp::NOpenDmarc {

class TDmarcException : public std::runtime_error {
public:
    explicit TDmarcException(const std::string& message)
        : std::runtime_error(message) {}
};

class TDmarcParseError : public TDmarcException {
public:
    explicit TDmarcParseError(const OPENDMARC_STATUS_T& result)
        : TDmarcException(opendmarc_policy_status_to_str(result)) {}
};

}  // namespace NNwSmtp::NOpenDmarc
