#include "failure_options.h"
#include "exceptions.h"

#include <libopendmarc/dmarc.h>

#include <cassert>

namespace NNwSmtp::NOpenDmarc {

const char* ToString(EFailureOptions failureOptions) {
    switch (failureOptions) {
        case EFailureOptions::Unspecified:
            return "Unspecified";
        case EFailureOptions::All:
            return "All";
        case EFailureOptions::Any:
            return "Any";
        case EFailureOptions::Dkim:
            return "Dkim";
        case EFailureOptions::Spf:
            return "Spf";
    }
    assert(false);
    return "";
}

EFailureOptions ToFailureOptions(int failureOptions) {
    switch (failureOptions) {
        case DMARC_RECORD_FO_UNSPECIFIED:
            return EFailureOptions::Unspecified;
        case DMARC_RECORD_FO_0:
            return EFailureOptions::All;
        case DMARC_RECORD_FO_1:
            return EFailureOptions::Any;
        case DMARC_RECORD_FO_D:
            return EFailureOptions::Dkim;
        case DMARC_RECORD_FO_S:
            return EFailureOptions::Spf;
        default:
            throw TDmarcException("Unknown failure options");
    }
}

}  // namespace NNwSmtp::NOpenDmarc
