#include "outcome.h"

#include <libopendmarc/dmarc.h>

#include <cassert>

namespace NNwSmtp::NOpenDmarc {

// Same for DKIM
int ToRaw(EOutcome outcome) {
    switch (outcome) {
        case EOutcome::None:
            return DMARC_POLICY_SPF_OUTCOME_NONE;
        case EOutcome::Pass:
            return DMARC_POLICY_SPF_OUTCOME_PASS;
        case EOutcome::Fail:
            return DMARC_POLICY_SPF_OUTCOME_FAIL;
        case EOutcome::TmpFail:
            return DMARC_POLICY_SPF_OUTCOME_TMPFAIL;
    }
    assert(false);
    return 0;
}

const char* ToString(EOutcome outcome) {
    switch (outcome) {
        case EOutcome::None:
            return "None";
        case EOutcome::Pass:
            return "Pass";
        case EOutcome::Fail:
            return "Fail";
        case EOutcome::TmpFail:
            return "TmpFail";
    }
    assert(false);
    return "";
}

}  // namespace NNwSmtp::NOpenDmarc
