#pragma once

#include "context.h"
#include "domain_policy.h"
#include "alignment_mode.h"
#include "failure_options.h"

#include <vector>
#include <string>

namespace NNwSmtp::NOpenDmarc {

struct TRecord {
    EDomainPolicy DomainPolicy;
    EDomainPolicy SubDomainPolicy;
    EAlignMode Adkim;
    EAlignMode Aspf;
    uint32_t Pct;
    EFailureOptions FailureOpts;
    std::vector<std::string> Rua;
};

using TRecordPtr = std::unique_ptr<TRecord>;

class TDmarcParser {
public:
    explicit TDmarcParser(const DMARC_POLICY_T* pctx);
    static TDmarcParser Parse(
        DMARC_POLICY_T* pctx,
        const std::string& fromDomain,
        const std::string& record);
    TRecordPtr MakeRecord() const ;
    EDomainPolicy GetDomainPolicy() const;
    EDomainPolicy GetSubDomainPolicy() const;
    EAlignMode GetAdkim() const;
    EAlignMode GetAspf() const;
    uint32_t GetPct() const;
    EFailureOptions GetFailureOptions() const ;
    std::vector<std::string> GetRua() const;

private:
    const DMARC_POLICY_T* Pctx;
};

}  // namespace NNwSmtp::NOpenDmarc
