#pragma once

#include "dmarc_policy.h"
#include "alignment.h"
#include "outcome.h"
#include "spf_origin.h"
#include <libopendmarc/dmarc.h>

#include <string>

namespace NNwSmtp::NOpenDmarc {

class TPolicyManager {
public:
    TPolicyManager(
        DMARC_POLICY_T* pctx,
        const std::string& fromDomain,
        const std::string& txtRecord,
        const std::string& organizationalDomain = std::string());
    void SetSpf(const std::string& fromDomain, EOutcome outcome, ESpfOrigin origin);
    void SetDkim(const std::string& dEqualDomain, EOutcome outcome);
    EDmarcPolicy AdvisePolicy();
    TAlignments GetAlignments() const;

private:
    DMARC_POLICY_T* Pctx;
};

}  // namespace NNwSmtp::NOpenDmarc
