#include "domains_set.h"
#include "file_converter.h"

namespace NNwSmtp {

void TDomainsSet::LoadTo(const std::string& src, TContainer& dst) {
    if (src.empty()) {
        return;
    }
    if (src.front() == '@') {
        dst.insert(boost::to_lower_copy(src.substr(1)));
    } else {
        TFileConverter::ToSet(src, dst, NConverters::TToLower());
    }
}

}   // namespace NNwSmtp


