#include "envelope.h"
#include "context.h"
#include "log.h"
#include "options.h"

#include <mail/nwsmtp/src/types.h>

#include <boost/algorithm/string.hpp>
#include <boost/format.hpp>

#include <memory>

namespace NNwSmtp {

envelope::envelope()
        : added_headers_(),
          orig_message_(),
          altered_message_(),
          orig_message_body_beg_(),
          orig_message_size_(0),
          header_storage_(std::make_shared<THeaderStorageImpl>()),
          filtered_header_storage_(std::make_shared<THeaderStorageImpl>()),
          xyandex_hint_header_value_(),
          m_id(generate_new_id()),
          m_sender(),
          m_spam(false),
          m_no_local_relay(false),
          added_message_id_(false),
          is_mailing_list_(false)
{
}

bool envelope::add_recipient(
    const std::string &_rcpt,
    uint64_t _suid,
    bool is_alias,
    const std::string& _uid,
    const std::string& _ml_uid,
    const std::string& _default_email,
    const std::string& _country_code,
    DomainType domainType,
    int notify_mode,
    bool phone_confirmed,
    bool is_maillist,
    std::time_t regDate,
    bool need_update_limits
) {
    if (m_rcpts.Contains(_rcpt)) {
        return true;
    }

    if (m_rcpts.GetByUid(_uid)) {
        return false;
    }

    TRcpt rcpt{_rcpt, _uid};

    rcpt.domainType = domainType;

    rcpt.m_suid = _suid;

    rcpt.m_ml_uid = _ml_uid;

    rcpt.m_default_email = _default_email;

    rcpt.m_spam_status = NSO::EResolution::SO_RESOLUTION_SKIP;

    rcpt.country_ = _country_code;

    rcpt.is_alias_ = is_alias;

    rcpt.need_update_limits = need_update_limits;

    rcpt.m_notify_mode = notify_mode;
    rcpt.m_phone_confirmed = phone_confirmed;

    rcpt.is_maillist_ = is_maillist;
    rcpt.registrationDate = regDate;

    m_rcpts.Add(rcpt);

    return true;
}

static char code_table[] = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwx";

std::string envelope::generate_new_id()
{

    std::string res;
    time_t now;

    struct tm *lt;

    int pid = getpid();
    unsigned long tid = (unsigned long)pthread_self();

    time( &now );
    lt = localtime( &now );

    res += code_table[ lt->tm_min ];
    res += code_table[ lt->tm_sec ];
    res += code_table[ pid % 60 ];
    res += code_table[ tid % 60 ];
    res += code_table[ rand() % 60 ];
    res += code_table[ rand() % 60 ];
    res += code_table[ rand() % 60 ];
    res += code_table[ rand() % 60 ];

    return res;
}

void envelope::init_all_recipients()
{
    for (auto& rcpt : m_rcpts)
    {
        rcpt.m_delivery_status = check::CHK_TEMPFAIL;
    }
}

void envelope::cleanup_answers()
{
    for(auto& rcpt : m_rcpts)
    {
        rcpt.m_remote_answer.clear();
    }
}

} // namespace NNwSmtp
