#pragma once

#include <sys/types.h>
#include <string>
#include <boost/noncopyable.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/enable_shared_from_this.hpp>

#include "rcpt.h"
#include "rcpts.h"

#include <nwsmtp/avir_client.h>
#include "check.h"
#include "address_parser.h"
#include <mail/library/dsn/options.hpp>
#include "header_storage.h"
#include <mail/nwsmtp/src/bb_result.h>
#include <mail/nwsmtp/src/so/types.h>

#include <mail/nwsmtp/src/types.h>

#include <memory>

namespace NNwSmtp {

struct envelope
        : public boost::enable_shared_from_this<envelope>,
          private boost::noncopyable

{
    typedef std::list<TRcpt> rcpt_list_t;

    envelope();

    bool add_recipient(
        const std::string &_rcpt,
        uint64_t _suid,
        bool is_alias,
        const std::string& _uid,
        const std::string& _ml_uid,
        const std::string& _default_email,
        const std::string& _country_code,
        DomainType domainType = DomainType::UNKNOWN,
        int notify_mode = dsn::Options::NONE,
        bool phone_confirmed = false,
        bool is_maillist = false,
        std::time_t regDate = 0,
        bool need_update_limits = true
    );

    bool has_recipient(const std::string& uid);

    void init_all_recipients();

    template <typename TRange>
    void copy_dlv_status(TRange range)
    {
        auto begin = range.begin();
        for (; begin != range.end(); ++begin)
        {
            if (auto* rcpt = m_rcpts.GetByEmail(begin->m_name))
            {
                rcpt->m_delivery_status = begin->m_delivery_status;
                rcpt->m_remote_answer = begin->m_remote_answer;
            }
        }
    }

    static std::string generate_new_id();

    void cleanup_answers();

    NNwSmtp::TBuffer added_headers_;
    NNwSmtp::TBuffer orig_message_;
    std::string received_headers_;
    std::string altered_message_;

    TBufferIterator orig_message_body_beg_;
    std::size_t orig_message_size_;

    std::shared_ptr<THeaderStorageImpl> header_storage_;
    std::shared_ptr<THeaderStorageImpl> filtered_header_storage_;
    std::string xyandex_hint_header_value_;
    std::vector<std::string> xyandex_hint_header_value_personal_;

    std::string m_id;
    std::string m_sender;
    std::string address_sender_from_mailbody;
    std::string m_sender_uid;
    std::string m_sender_default_email;
    TRcpts m_rcpts;
    bool m_spam = false;
    bool m_no_local_relay = false; // no local relay if we have one or more aliases

    TBufferRange header_sender_;
    TBufferRange header_from_;

    std::string message_id_;
    std::string m_original_id;
    bool added_message_id_;

    avir_client::status avirStatus = avir_client::unknown;

    bool is_mailing_list_;
    std::string ml_address_;

    bool is_sender_in_rcpts_ = false;  // Has the user added sender to recipient list?
    std::list<std::string> so_labels_;
    NSO::EResolution so_status = NSO::EResolution::SO_RESOLUTION_SKIP;
    bool sender_added_for_control = false;

    TBlackBoxResultOpt senderInfo;

    std::string foreign_mx;

    std::string so_headers;
};

typedef boost::shared_ptr<envelope> envelope_ptr;
typedef boost::weak_ptr<envelope> envelope_weak_ptr;

} // namespace NNwSmtp
