#pragma once

#include "parser.h"

#include <mail/nwsmtp/src/context.h>

#include <ymod_httpclient/call.h>
#include <yplatform/coroutine.h>
#include <yplatform/time_traits.h>

#include <functional>
#include <memory>
#include <string>

namespace NFouras {

class TClient {
public:
    using TYieldCtx = yplatform::yield_context<TClient>;
    using THttpClientPtr = std::shared_ptr<ymod_httpclient::cluster_call>;
    using TCallback = std::function<void(boost::system::error_code ec, TKeyEntry key)>;

    TClient(
        THttpClientPtr httpClient,
        std::string domain,
        NNwSmtp::TContextPtr context,
        TCallback callback);

    void operator()(
        TYieldCtx yieldCtx,
        boost::system::error_code ec = {},
        yhttp::response response = {});

private:
    void WriteLog(const boost::system::error_code& ec);

private:
    THttpClientPtr HttpClient;
    std::string Domain;
    NNwSmtp::TContextPtr Context;
    TCallback Callback;

    yplatform::time_traits::time_point StartedAt;
};

} // namespace NFouras
