#include "errors.h"

namespace NFouras {

EErrorCode FromHttpStatus(int httpStatus) {
    if (httpStatus >= 500) {
        return EC_SERVER_ERROR;
    }

    switch (httpStatus) {
        case 200:
            return EC_OK;
        case 400:
            return EC_BAD_REQUEST;
        case 401:
            return EC_UNAUTHORIZED;
        case 403:
            return EC_PERMISSION_DENIED;
        case 404:
            return EC_NOT_FOUND;
        default:
            return EC_UNKNOWN;
    }
}

class TErrorCategory : public boost::system::error_category {
public:
    const char* name() const noexcept override {
        return "Fouras client";
    }

    std::string message(int ev) const override {
        switch (ev) {
            case EC_OK:
                return "Ok";
            case EC_DOMAIN_NOT_FOUND:
                return "Domain not found";
            case EC_DISABLED:
                return "Disabled";
            case EC_PARSE_ERROR:
                return "Fail to parse response";
            case EC_BAD_REQUEST:
                return "Bad request";
            case EC_UNAUTHORIZED:
                return "Unauthorized";
            case EC_PERMISSION_DENIED:
                return "Permission denied";
            case EC_NOT_FOUND:
                return "Not found";
            case EC_SERVER_ERROR:
                return "Server error";
            case EC_UNKNOWN:
                break;
        }

        return "Unknown error";
    }
};

const TErrorCategory errorCategory{};

boost::system::error_code make_error_code(EErrorCode code) {
    return {code, errorCategory};
}

}  // namespace NFouras
