#pragma once

#include <boost/system/error_code.hpp>

namespace NFouras {

enum EErrorCode {
    EC_OK = 0,

    // результат разбора ответа
    EC_DOMAIN_NOT_FOUND,
    EC_DISABLED,
    EC_PARSE_ERROR,

    // http-коды
    EC_BAD_REQUEST,
    EC_UNAUTHORIZED,
    EC_PERMISSION_DENIED,
    EC_NOT_FOUND,
    EC_SERVER_ERROR,

    // прочее
    EC_UNKNOWN
};

EErrorCode FromHttpStatus(int httpStatus);

boost::system::error_code make_error_code(EErrorCode code);

}  // namespace NFouras

namespace boost {
namespace system {

template <>
struct is_error_code_enum<NFouras::EErrorCode> : std::true_type{};

}  // namespace system
}  // namespace boost
