#pragma once

#include "errors.h"

#include <ymod_httpclient/call.h>

#include <string>
#include <utility>

namespace NFouras {

struct TKeyEntry {
    std::string Selector;
    std::string Domain;
    std::string SecretKey;
};

std::pair<EErrorCode, TKeyEntry> ParseResponse(const yhttp::response& response);
std::pair<EErrorCode, TKeyEntry> ParseSuccessResponse(const std::string& body);
EErrorCode ParseNotFoundResponse(const std::string& body);

} // namespace NFouras
