#pragma once

#include "types.h"

#include <mail/nwsmtp/src/types.h>
#include <mail/nwsmtp/src/context.h>
#include <mail/nwsmtp/src/error_code.h>

#include <functional>
#include <string>

namespace NNwSmtp::NMailFromCommand {

using TCallback = std::function<void(TErrorCode ec, TResponse resp)>;

struct IMailFromCommand {
    virtual ~IMailFromCommand() = default;

    virtual void Run(TContextPtr context, TRequest request, TCallback cb) = 0;
};

using TMailFromCommandPtr = std::shared_ptr<IMailFromCommand>;

} // namespace NNwSmtp::NMailFromCommand

