#include "error_code.h"
#include "convert_ec_to_smtp_answer.h"

namespace NNwSmtp::NMailFromCommand {

std::string ConvertErrorCodeToSmtpAnswer(const TErrorCode& ec, const std::string& mailFrom) {
    if (!ec) {
        return "250 2.1.0 <" + mailFrom + "> ok";
    }

    if (ec == EError::MailAddrIsTooLong) {
        return "501 5.1.7 Path too long.";
    }

    if (ec == EError::MailAddrIsInvalid) {
        return "501 5.1.7 Bad address mailbox syntax.";
    }

    if (ec == EError::MessageSizeExceedsLimit) {
        return "552 5.3.4 Message size exceeds fixed limit.";
    }

    if (ec == EError::NotAuthorized) {
        return "503 5.5.4 Error: send AUTH command first.";
    }

    if (ec == EError::AuthReject) {
        return "421 4.7.0 Authorization expired!";
    }

    if (ec == EError::RejectAddrNotOwnedByAuthUser) {
        return "553 5.7.1 Sender address rejected: not owned by auth user.";
    }

    if (ec == EError::RejectAddrUserNotFound) {
        return "553 5.7.1 Sender address rejected: user not found.";
    }

    if (ec == EError::RejectRateSrv) {
        return "450 4.2.1 Too many messages from <" + mailFrom + ">. Try again later.";
    }

    if (ec == EError::TempFail) {
        return "454 4.3.0 Try again later";
    }

    return "451 4.3.0 Service unavailable. Try again later.";
}

ymod_smtpserver::Response ConvertErrorCodeToYmodSmtpAnswer(const TErrorCode& ec, const std::string& mailFrom) {
    if (!ec) {
        return ymod_smtpserver::Response(250, "<" + mailFrom + "> ok", ymod_smtpserver::EnhancedStatusCode(210));
    }

    if (ec == EError::MailAddrIsTooLong) {
        return ymod_smtpserver::Response(501, "Path too long.", ymod_smtpserver::EnhancedStatusCode(517));
    }

    if (ec == EError::MailAddrIsInvalid) {
        return ymod_smtpserver::Response(501, "Bad address mailbox syntax.", ymod_smtpserver::EnhancedStatusCode(517));
    }

    if (ec == EError::MessageSizeExceedsLimit) {
        return ymod_smtpserver::Response(552, "Message size exceeds fixed limit.", ymod_smtpserver::EnhancedStatusCode(534));
    }

    if (ec == EError::NotAuthorized) {
        return ymod_smtpserver::Response(503, "Error: send AUTH command first.", ymod_smtpserver::EnhancedStatusCode(554));
    }

    if (ec == EError::AuthReject) {
        return ymod_smtpserver::Response(421, "Authorization expired.", ymod_smtpserver::EnhancedStatusCode(470));
    }

    if (ec == EError::RejectAddrNotOwnedByAuthUser) {
        return ymod_smtpserver::Response(553, "Sender address rejected: not owned by auth user.", ymod_smtpserver::EnhancedStatusCode(571));
    }

    if (ec == EError::RejectAddrUserNotFound) {
        return ymod_smtpserver::Response(553, "Sender address rejected: user not found.", ymod_smtpserver::EnhancedStatusCode(571));
    }

    if (ec == EError::RejectRateSrv) {
        return ymod_smtpserver::Response(450, "Too many messages from <" + mailFrom + ">. Try again later.", ymod_smtpserver::EnhancedStatusCode(421));
    }

    if (ec == EError::TempFail) {
        return ymod_smtpserver::Response(454, "Try again later.", ymod_smtpserver::EnhancedStatusCode(430));
    }

    return ymod_smtpserver::Response(451, "Service unavailable. Try again later.", ymod_smtpserver::EnhancedStatusCode(430));
}

}
