#pragma once

#include <mail/nwsmtp/src/bb_result.h>
#include <mail/nwsmtp/src/auth.h>

#include <boost/asio/ip/address.hpp>

#include <optional>
#include <string>
#include <map>

namespace NNwSmtp::NMailFromCommand {

struct TConfig {
    bool BlackBoxCheckSender = false;
    bool CheckSPF = false;
    bool UseAuth = false;
    bool CheckSenderSyntax = false;
    std::size_t MessageSizeLimit = 0;
};

struct TRequest {
    std::string MailAddr;
    std::map<std::string, std::string> Params;
    std::string HeloHost;
    boost::asio::ip::address Ip;
    std::size_t BBSessionSuid = 0;

    bool IsAuthenticated = false;
    bool NeedCheckAuth = false;
    TAuthData Auth;
};

struct TSPFResponse {
    std::optional<std::string> Result;
    std::optional<std::string> Explain;
};

struct TCheckAuthResponse {
    std::size_t BBSessionSuid = 0;
    std::string BBSessionLogin;
};

struct TCheckBBResponse {
    TBlackBoxResult BBResult;
};

struct TResponse {
    std::optional<TSPFResponse> SPFResponse;
    std::optional<TCheckAuthResponse> CheckAuthResponse;
    std::optional<TCheckBBResponse> CheckBBResponse;

    std::string SmtpAnswer;
};

} // namespace NNwSmtp::NMailFromCommand
