#include "match.h"
#include "file_converter.h"

namespace NNwSmtp {

void Match::load(const std::string& filename) {
    std::vector<std::string> patterns;
    TFileConverter::ToVector(filename, patterns);
    for (const auto& pattern : patterns) {
        add(pattern);
    }
}

void Match::add(const std::string& pattern) {
    regs.push_back(
        boost::regex(boost::trim_copy(pattern), boost::regex::perl | boost::regex::icase)
    );
}

bool Match::isMatch(const std::string& what) const {
    for(const auto& reg : regs) {
        if (boost::regex_match(what, reg)) {
            return true;
        }
    }
    return false;
}

}   // namespace NNwSmtp
