#pragma once

#include <string>
#include <vector>
#include <boost/regex.hpp>

namespace NNwSmtp {

class Match {
public:
    void load(const std::string& filename);

    template <typename Iterator>
    void load(Iterator first, Iterator last) {
        for (; first != last; ++first) {
            if (!first->second.data().empty()) {
                add(first->second.data());
            }
        }
    }

    bool isMatch(const std::string &what) const;

private:
    void add(const std::string& pattern);

    using Regexs = std::vector<boost::regex>;
    Regexs regs;
};

}   // namespace NNwSmtp
