#pragma once

#include "types.h"

#include <mail/nwsmtp/src/context.h>

#include <functional>
#include <memory>

namespace NNwSmtp::NMds {

using TGetPutCallback = std::function<void(boost::system::error_code, std::string)>;

struct IMdsClient {
    virtual ~IMdsClient() = default;

    virtual void Put(TContextPtr, TPutRequest, TGetPutCallback) = 0;
    virtual void Get(TContextPtr, std::string, TGetPutCallback) = 0;
};

using TMdsClientPtr = std::shared_ptr<IMdsClient>;

} // namespace NNwSmtp::NMds
