#include "client_impl.h"
#include "error_code.h"
#include "utils.h"

#include <mail/nwsmtp/src/log.h>

namespace NNwSmtp::NMds {

void TMdsClient::Put(TContextPtr context, TPutRequest request, TGetPutCallback callback) {
    auto stid = ::NMds::MakeStid(request.Uid, request.Uid.empty());
    auto nsType = request.IsSpam ? ::NMds::NS_SPAM : ::NMds::NS_MAIL;
    std::string message;

    try {
        message = MakeMessage(request.Headers, request.AddedHeaders, request.Body, request.RemoveHeaders);
    } catch (const std::exception& exc) {
        using namespace std::string_literals;
        NWLOG_CTX(error, context, "MDS", "failed to make message: "s + exc.what());
        return callback(EError::EC_MAKE_MESSAGE, {});
    }

    auto handler = [ex = Io.get_executor(), callback = std::move(callback)]
        (auto ec, auto response) {
            boost::asio::post(ex, std::bind(callback, std::move(ec), std::move(response)));
        };

    Client->Put(context->CreateTaskContext("MDS:"), stid, message, nsType, std::move(handler));
}

void TMdsClient::Get(TContextPtr context, std::string stid, TGetPutCallback callback) {
    auto handler = [ex = Io.get_executor(), callback = std::move(callback)]
        (auto ec, auto response) {
            boost::asio::post(ex, std::bind(callback, std::move(ec), std::move(response)));
        };

    Client->Get(context->CreateTaskContext("MDS:"), stid, std::move(handler));
}

}  // namespace NNwSmtp::NMds
