#pragma once

#include "client.h"

#include <mail/ymod_mds/src/client.h>

#include <boost/asio.hpp>

#include <memory>

namespace NNwSmtp::NMds {

struct TMdsClient: IMdsClient {
    using TClientPtr = std::shared_ptr<::NMds::TClient>;

    TMdsClient(TClientPtr client, boost::asio::io_context& io)
        : Client(std::move(client))
        , Io(io) {}

    void Put(TContextPtr context, TPutRequest request, TGetPutCallback callback) override;
    void Get(TContextPtr context, std::string stid, TGetPutCallback callback) override;

private:
    TClientPtr Client;
    boost::asio::io_context& Io;
};

}  // namespace NNwSmtp::NMds
