#pragma once

#include <boost/system/error_code.hpp>

namespace NNwSmtp::NMds {

enum class EError {
    EC_MAKE_MESSAGE = 1,
};

} // NNwSmtp::NMds

namespace boost::system {

template <>
struct is_error_code_enum<NNwSmtp::NMds::EError> : std::true_type {};

} // namespace boost::system

namespace NNwSmtp::NMds {

class TErrorCategory final : public boost::system::error_category {

public:
    const char* name() const noexcept override {
        return "nwsmtp_mds";
    }

    std::string message(int value) const override {
        switch (static_cast<EError>(value)) {
            case EError::EC_MAKE_MESSAGE:
                return "Failed to make message";
        }
        return "Unknown error code: " + std::to_string(value);
    }
};

inline const TErrorCategory& getErrorCategory() {
    static TErrorCategory errorCategory;
    return errorCategory;
}

inline auto make_error_code(EError ec) {
    return boost::system::error_code(static_cast<int>(ec), getErrorCategory());
}

} // namespace NNwSmtp::NMds
