#pragma once

#include <mail/nwsmtp/src/utils.h>

#include <mail/yplatform/include/yplatform/zerocopy/streambuf.h>

#include <util/generic/is_in.h>

namespace NNwSmtp::NMds {

template <class THeaders, class TBody>
std::string MakeMessage(
    const THeaders& headers,
    const TBuffer& addedHeaders,
    const TBody& body,
    const TCaseInsensitiveHashSet& removeHeaders
) {
    using NNwSmtp::NUtil::ToString;

    yplatform::zerocopy::streambuf buf;
    std::ostream ostream(&buf);

    bool hasHeaders = false;
    for (const auto& header : headers.GetAllHeaders()) {
        if (IsIn(removeHeaders, ToString(header.Name))) {
            continue;
        }
        ostream << ToString(header.GetWhole()) << "\r\n";
        hasHeaders = true;
    }
    if (!hasHeaders) {
        throw std::runtime_error("No headers while making message for mds");
    }

    ostream << "\r\n";
    for (const auto& chunk : body) {
        ostream << chunk;
    }

    ostream << std::flush;
    auto tBuffer = buf.detach(buf.end());
    return NUtil::ToString(addedHeaders).append(NUtil::ToString(tBuffer));
}

} // namespace NNwSmtp::NMds
