#pragma once

#include "types.h"

#include <mail/nwsmtp/src/context.h>
#include <mail/nwsmtp/src/types.h>

#include <functional>
#include <memory>

namespace NNwSmtp::NML {

struct IClient {
    using TCallback = std::function<void(TErrorCode, TResponse)>;

    virtual ~IClient() = default;
    virtual void Run(TContextPtr, TRequest, TCallback) = 0;
};

using TClientPtr = std::shared_ptr<IClient>;

} // namespace NNwSmtp::NML
