#pragma once

#include "client.h"
#include "types.h"

#include <mail/nwsmtp/src/context.h>
#include <mail/nwsmtp/src/options.h>

#include <yplatform/time_traits.h>
#include <ymod_httpclient/call.h>

#include <boost/asio.hpp>

#include <memory>

enum list_client_ec
{
    PARSE_ERROR = 1,
    NOT_FOUND,
    INVALID_CODE
};

namespace boost {
namespace system {

template <>
struct is_error_code_enum<list_client_ec>
{
    static const bool value = true;
};

} // namespace system
} // namespace boost

const boost::system::error_category & get_list_client_category();

boost::system::error_code make_error_code(list_client_ec e);


namespace NNwSmtp::NML {

std::string normalize(const std::string& s);

TResponse parse_ml_data(const std::string& data);

yhttp::request makeRequest(const std::string& baseUrl, const std::string& email);

yhttp::options makeOptions(const Options::LLOpts&);

class TClient: public IClient, public std::enable_shared_from_this<TClient> {
public:
    using THttpClientPtr = std::shared_ptr<yhttp::simple_call>;
    TClient(Options::LLOpts settings, THttpClientPtr httpClient, boost::asio::io_context& io)
        : Settings(std::move(settings))
        , HttpClient(std::move(httpClient))
        , Io(io) {}

    void Run(TContextPtr context, TRequest request, TCallback callback) final;

private:
    Options::LLOpts Settings;
    THttpClientPtr HttpClient;
    boost::asio::io_context& Io;
};

}   // namespace NNwSmtp::NML
