#pragma once

#include "client.h"
#include "types.h"

#include <mail/ymod_httpclient/include/ymod_httpclient/cluster_client.h>

#include <boost/asio.hpp>

#include <memory>

namespace NNwSmtp::NNsls {

struct TNslsClient: INslsClient {

    using TClientPtr = std::shared_ptr<ymod_httpclient::cluster_call>;

    TNslsClient(TClientPtr client, boost::asio::io_context& io)
        : Client(std::move(client))
        , Io(io) {}

    void Store(TContextPtr, TRequest, TCallback) override;

private:
    static void HandleStore(TContextPtr, TCallback, const TErrorCode&, yhttp::response);

    TClientPtr Client;
    boost::asio::io_context& Io;
};

} // namespace NNwSmtp::NNsls
