#pragma once

#include <boost/system/error_code.hpp>

namespace NNwSmtp::NNsls {

enum class EError {
    EC_PARSE_ERROR = 1,
    EC_BAD_STATUS,
    EC_PERM_ERROR

};

} // NNwSmtp::NNsls

namespace boost::system {

template <>
struct is_error_code_enum<NNwSmtp::NNsls::EError> : std::true_type {};

} // namespace boost::system

namespace NNwSmtp::NNsls {

class TErrorCategory final : public boost::system::error_category {

public:
    const char* name() const noexcept override {
        return "nwsmtp_nsls";
    }

    std::string message(int value) const override {
        switch (static_cast<EError>(value)) {
            case EError::EC_PARSE_ERROR:
                return "Failed to parse response";
            case EError::EC_BAD_STATUS:
                return "Request to ended with not 200 status code";
            case EError::EC_PERM_ERROR:
                return "Request to ended with permanent error";
        }
        return "Unknown error code: " + std::to_string(value);
    }
};

inline const TErrorCategory& getErrorCategory() {
    static TErrorCategory errorCategory;
    return errorCategory;
}

inline auto make_error_code(EError ec) {
    return boost::system::error_code(static_cast<int>(ec), getErrorCategory());
}

} // namespace NNwSmtp::NNsls
