#include "make_response.h"
#include "utils.h"

namespace NNwSmtp::NNsls {

TResponse MakeResponse(const TStoreResponse& storeResponse) {
    TResponse response;
    response.Status = "error";
    for (const auto& recipient: storeResponse.recipients) {
        if (!recipient.status.has_value()) {
            continue;
        }

        if (recipient.status.value() == "decycled") {
            response.Status = "success";
            response.Success.IsDecycled = true;
            break;
        }

        if (recipient.status.value() == "deduplicated") {
            response.Status = "success";
            response.Success.IsDuplicate = true;
            if (recipient.delivery_result.has_value()) {
                response.Success.Mid = recipient.delivery_result->mid.value_or("");
            }
            break;
        }

        if (recipient.status.value() == "stored") {
            response.Status = "success";
            if (recipient.delivery_result.has_value()) {
                response.Success.Mid = recipient.delivery_result->mid.value_or("");
                response.Success.ImapId = recipient.delivery_result->imap_id.value_or("");
            }
            break;
        }

        if (recipient.status.value() == "temp_error") {
            response.Status = "error";
            break;
        }

        if (recipient.status.value() == "perm_error") {
            response.Status = "error";
            response.Error.IsPermanent = true;
            break;
        }

    }

    return response;
}

} // namespace NNwSmtp::NNsls
