#pragma once

#include <mail/nwsmtp/src/types.h>

#include <functional>
#include <map>
#include <optional>
#include <string>
#include <vector>


namespace NNwSmtp::NNsls {

struct TMailFrom {
    std::string email;
    std::string envid;
};

struct TEnvelope {
    std::string remote_ip;
    std::string remote_host;
    TMailFrom mail_from;
    std::string session_id;
    std::string envelope_id;
    std::string helo;
};

using THint = std::map<std::string, std::vector<std::string>>;
using THints = std::vector<THint>;

struct TMessage {
    std::string stid;
    std::string front;
    std::int64_t timemark = 0;
    bool spam = false;
    THints hints;
};

struct TNotification {
    bool success = false;
    bool failure = false;
    bool delay = false;
};

enum class ELocal {
    yes = 0  /* "yes" */,
    no = 1  /* "no" */,
    unknown = 2  /* "unknown" */
};

struct TDeliveryResult {
    std::optional<std::string> mid;
    std::optional<std::string> imap_id;
    std::optional<std::string> stid;
    std::optional<std::string> mail_from;
    std::optional<THints> hints;
};

struct TRecipient {
    std::string email;
    std::optional<std::string> uid;
    ELocal is_local = ELocal::unknown;
    TNotification notify;
    std::optional<bool> is_mailish = false;
    std::optional<TDeliveryResult> delivery_result;
    std::optional<std::string> status;
};

using TRecipients = std::vector<TRecipient>;

struct TRequest {
    TEnvelope envelope;
    TMessage message;
    TRecipients recipients;
    std::string requestId;
};

struct TStoreResponse {
    TRecipients recipients;
};

struct TNslsSuccessResponse {
    std::string Mid;
    std::string ImapId;
    bool IsDuplicate = false;
    bool IsDecycled = false;
};

struct TNslsErrorResponse {
    bool IsPermanent = false;
    std::string Code;
    std::string Message;
};

struct TResponse {
    std::string Status;
    TNslsSuccessResponse Success;
    TNslsErrorResponse Error;
};

using TCallback = std::function<void(TErrorCode, TResponse)>;

} // namespace NNwSmtp::NNsls
