#pragma once

#include "types.h"

#include <mail/yreflection/include/yamail/data/reflection.h>

#include <boost/fusion/adapted.hpp>

YREFLECTION_ADAPT_ENUM(NNwSmtp::NNsls::ELocal, yes, no, unknown)

BOOST_FUSION_ADAPT_STRUCT(NNwSmtp::NNsls::TMailFrom,
    email,
    envid
)

BOOST_FUSION_ADAPT_STRUCT(NNwSmtp::NNsls::TEnvelope,
    remote_ip,
    remote_host,
    mail_from,
    session_id,
    envelope_id,
    helo
)

BOOST_FUSION_ADAPT_STRUCT(NNwSmtp::NNsls::TMessage,
    stid,
    front,
    timemark,
    spam,
    hints
)

BOOST_FUSION_ADAPT_STRUCT(NNwSmtp::NNsls::TNotification,
    success,
    failure,
    delay
)

BOOST_FUSION_ADAPT_STRUCT(NNwSmtp::NNsls::TDeliveryResult,
    mid,
    imap_id,
    stid,
    mail_from,
    hints
)

BOOST_FUSION_ADAPT_STRUCT(NNwSmtp::NNsls::TRecipient,
    email,
    uid,
    is_local,
    notify,
    is_mailish,
    delivery_result,
    status
)

BOOST_FUSION_ADAPT_STRUCT(NNwSmtp::NNsls::TRequest,
    envelope,
    message,
    recipients
)

BOOST_FUSION_ADAPT_STRUCT(NNwSmtp::NNsls::TStoreResponse,
    recipients
)

BOOST_FUSION_ADAPT_STRUCT(NNwSmtp::NNsls::TNslsSuccessResponse,
    Mid,
    ImapId,
    IsDuplicate,
    IsDecycled
)

BOOST_FUSION_ADAPT_STRUCT(NNwSmtp::NNsls::TNslsErrorResponse,
    IsPermanent,
    Code,
    Message
)

BOOST_FUSION_ADAPT_STRUCT(NNwSmtp::NNsls::TResponse,
    Status,
    Success,
    Error
)
