#pragma once

#include "types.h"

#include "interface.h"

#include <mail/nwsmtp/src/mailfrom/command.h>
#include <mail/nwsmtp/src/rcpt_to/interface.h>
#include <mail/nwsmtp/src/so/client_impl.h>
#include <mail/nwsmtp/src/delivery/async/interface.h>

#include <mail/nwsmtp/src/settings_authorization/settings_authorization.h>

#include <mail/nwsmtp/src/context.h>

#include <boost/asio/io_context.hpp>
#include <boost/asio/ip/address.hpp>

#include <memory>

namespace NNwSmtp {

class TNwsmtpImpl : public INwSmtp, public std::enable_shared_from_this<TNwsmtpImpl> {
public:
    TNwsmtpImpl(NMailFromCommand::TMailFromCommandPtr mailFromCmd,
        NRcptTo::TRcptToCommandPtr rcptToCmd,
        NSettingsAuthorization::TSettingsAuthorizationPtr settingsAuthorization,
        NAsyncDlv::TAsyncDeliveryPtr delivery,
        boost::asio::io_context& ioContext
    );

    void SetEhloHost(std::string host) override;

    void SetRemoteIp(boost::asio::ip::address addr) override;

    void SetRemoteHostName(std::string host) override;

    void Auth(TAuthRequst req, TAuthCallback cb) override;

    bool IsAuthenticated() override;

    void MailFrom(TMailFromRequest req, TCallback cb) override;

    void RcptTo(TRcptToRequest req, TRcptToCallback cb) override;

    void Data(TDataRequest req) override;

    void Delivery(TDeliveryRequest req, TDeliveryCallback cb) override;

    void Reset() override;

    TContextPtr GetContext() override;

private:
    void HandleAuth(TErrorCode ec, NBlackBox::TResponse response, TAuthCallback cb);

    void HandleMailFrom(TErrorCode ec, NMailFromCommand::TResponse resp, TCallback cb);

    void HandleRcptTo(TErrorCode ec, NRcptTo::TResponse resp, TRcptToCallback cb);

    void HandleDeliver(TErrorCode ec, std::string answer, TDeliveryCallback cb);

private:
    NMailFromCommand::TMailFromCommandPtr MailFromCmd;
    NRcptTo::TRcptToCommandPtr RcptToCmd;
    NSettingsAuthorization::TSettingsAuthorizationPtr SettingsAuthorization;
    NAsyncDlv::TAsyncDeliveryPtr DeliveryClient;

    envelope_ptr Envelope;
    TContextPtr Context;

    TAuthData AuthData;
    std::size_t BBSessionSuid = 0;
    std::string BBSessionLogin;
    bool IsAuthenticatedFlag = false;
    std::size_t AuthCheckedOnMessageIdx = 0;

    std::string SessionId;
    boost::asio::ip::address RemoteAddr;
    std::string RemoteHostName;
    std::string EhloHost;

    std::string MailFromAddr;
    std::optional<std::string> OriginalEnvId;

    std::optional<std::string> SpfResponse;
    std::optional<std::string> SpfExplain;

    std::size_t MessagesCount = 0;
    std::uint32_t ErrorCount = 0;

    boost::asio::io_context& IoContext;
};

}
