#pragma once
 
#include "blackbox/response.h"
#include "types.h"
 
#include <mail/nwsmtp/src/types.h>
#include <mail/nwsmtp/src/context.h>

#include <boost/asio/ip/address.hpp>

#include <functional>
 
namespace NNwSmtp {

struct INwSmtp {
    using TCallback = std::function<void(TErrorCode)>;
    using TRcptToCallback = std::function<void(TErrorCode, std::string)>;
    using TDeliveryCallback = std::function<void(TErrorCode, std::string)>;
    using TAuthCallback = std::function<void(TErrorCode, NBlackBox::TResponse)>;

    virtual ~INwSmtp() = default;

    virtual void SetEhloHost(std::string) = 0;
    virtual void SetRemoteIp(boost::asio::ip::address) = 0;
    virtual void SetRemoteHostName(std::string host) = 0;

    virtual void Auth(TAuthRequst, TAuthCallback) = 0;
    virtual bool IsAuthenticated() = 0;
    virtual void MailFrom(TMailFromRequest, TCallback) = 0;

    virtual void RcptTo(TRcptToRequest, TRcptToCallback) = 0;

    virtual void Data(TDataRequest) = 0;
    virtual void Delivery(TDeliveryRequest, TDeliveryCallback) = 0;

    virtual void Reset() = 0;

    virtual TContextPtr GetContext() = 0;
};

using TNwSmtpPtr = std::shared_ptr<INwSmtp>;

};
