#include <fstream>
#include "public_suffix_list.h"
#include "log.h"

public_suffix_list g_public_suffixes;

bool public_suffix_list::load(const std::string &path)
{
    std::ifstream file(path.c_str(), std::ios::in);
    if (!file.good())
        return false;

    for (std::string line; std::getline(file, line);)
    {
        if (line.compare(0, 2, "//") == 0)
        {
            std::string::size_type pos = line.find("xn-");
            if (pos != std::string::npos)
            {
                std::string::size_type space_pos = line.find_first_of(" \t", pos);
                m_suffixes.insert(line.substr(pos, space_pos != std::string::npos ? space_pos - pos : space_pos));
            }
            continue;
        }

        if (line.compare(0, 2, "*.") == 0)
            m_suffixes.insert(line.substr(1));
        else if (line[0] == '!')
            m_exceptions.insert(line.substr(1));
        else
            m_suffixes.insert(line);
    }

    return true;
}

std::string public_suffix_list::find_tld(const std::string &domain) const
{
    for (std::string::size_type pos = 0, dot_pos; pos < domain.length(); pos = dot_pos + 1)
    {
        if (m_exceptions.find(domain.substr(pos)) != m_exceptions.end())
            return domain.substr(pos);

        if ((dot_pos = domain.find('.', pos)) == std::string::npos)
            break;

        if (m_suffixes.find(domain.substr(dot_pos + 1)) != m_suffixes.end())
            return domain.substr(pos);

        if (m_suffixes.find(domain.substr(dot_pos)) != m_suffixes.end())
        {
            std::string::size_type prev_dot_pos = domain.rfind('.', dot_pos - 1);
            if (prev_dot_pos == std::string::npos)
                break;
            if ((prev_dot_pos = domain.rfind('.', prev_dot_pos - 1)) == std::string::npos)
                break;
            return domain.substr(prev_dot_pos + 1);
        }
    }
    return domain;
}

void GlobalLoadPublicSuffixList(const std::string& publicSuffixListFile) {
    if (!publicSuffixListFile.empty()) {
        if (g_public_suffixes.load(publicSuffixListFile)) {
            NWLOG_MSG(notice, "Load public suffix list file: name='" + publicSuffixListFile + "'");
        } else {
            throw std::logic_error("Can't load public suffix list file: name='" + publicSuffixListFile + "'");
        }
    }
}
