#include "randgen.h"

#include <util/random/random.h>

constexpr char ALPHA_NUMERIC[] = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
constexpr uint32_t MAX_IDX = sizeof(ALPHA_NUMERIC) - 1;

namespace NNwSmtp {

std::string GenRandomString(size_t length) {
    std::string string;
    string.reserve(length);
    for (size_t idx = 0; idx < length; idx++) {
        string.push_back(ALPHA_NUMERIC[RandomNumber<uint32_t>(MAX_IDX)]);
    }
    return string;
}

}  // namespace NNwSmtp
