#include "interface.h"

#include <yplatform/time_traits.h>
#include <yplatform/algorithm/leaky_bucket.h>
#include <yplatform/module.h>
#include <yplatform/reactor.h>

#include <boost/asio/io_context.hpp>

#include <atomic>
#include <cstddef>
#include <memory>
#include <mutex>

namespace NNwSmtp::NRateLimiter {

struct TRequestsRateLimiterImplSettings {
    std::size_t RcptToLimit = 0;
    std::size_t RcptToLeakFactor = 0;
    yplatform::time_traits::duration RcptToLeakInterval;

    std::size_t DataLimit = 0;
    std::size_t DataLeakFactor = 0;
    yplatform::time_traits::duration DataLeakInterval;
};

class TRequestsRateLimiterImpl : public std::enable_shared_from_this<TRequestsRateLimiterImpl> {
public:
    TRequestsRateLimiterImpl(TRequestsRateLimiterImplSettings settings);

    void OnStartRcptTo();
    void OnEndRcptTo();
    bool CheckLimitRcptTo();

    void OnStartData();
    void OnEndData();
    bool CheckLimitData();

private:
    std::mutex Mtx;

    TRequestsRateLimiterImplSettings Settings;

    yplatform::leaky_bucket<std::size_t> RcptToLeakyBucket;
    yplatform::leaky_bucket<std::size_t> DataLeakyBucket;
};

}
