#pragma once

#include <cstddef>
#include <memory>

namespace NNwSmtp::NRateLimiter {

struct IRequestsRateLimiter {
    virtual ~IRequestsRateLimiter() = default;

    virtual void OnStartRcptTo()  = 0;
    virtual void OnEndRcptTo() = 0;
    virtual bool CheckLimitRcptTo() = 0;

    virtual void OnStartData() = 0;
    virtual void OnEndData() = 0;
    virtual bool CheckLimitData() = 0;
};

using TRequestsRateLimiterPtr = std::shared_ptr<IRequestsRateLimiter>;

}
