#include "error_code.h"

namespace NNwSmtp::NRateSrv {

const char* TErrorCategory::name() const noexcept {
    return "nwsmtp_ratesrv";
}

std::string TErrorCategory::message(int value) const {
    switch (static_cast<EError>(value)) {
        case EError::Accept:
            return "Accept";
        case EError::Reject:
            return "Reject";
        case EError::Discard:
            return "Discard";
    }
    return "Unknown error code: " + std::to_string(value);
}

const TErrorCategory& GetErrorCategory() {
    static TErrorCategory errorCategory;
    return errorCategory;
}

boost::system::error_code make_error_code(EError ec) {
    return boost::system::error_code {static_cast<int>(ec), GetErrorCategory()};
}

} // namespace NNwSmtp::NRateSrv
