#pragma once

#include <mail/nwsmtp/src/types.h>

#include <string>

namespace NNwSmtp::NSO::NRBL {

using TCallback = std::function<void(TErrorCode ec, bool foundInSpam)>;

struct IClient {
    virtual void AsyncCheck(TContextPtr ctx, std::string ip, TCallback cb) = 0;
    virtual ~IClient() = default;
};

using IClientPtr = std::shared_ptr<IClient>;

} // namespace NNwSmtp::NSO::NRBL
